<!doctype html>
<html>
	<head>
		<!--<script src="js/menu.js" type="text/javascript"></script>-->
		<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
		<meta charset="UTF-8">
		<link href="https://fonts.googleapis.com/css?family=Open+Sans:400,600" rel="stylesheet" type="text/css">
		<link rel="stylesheet" href="css/font-awesome.min.css">
		<link href="css/style.min.css" rel='stylesheet' type='text/css'>
		<title>Web Design and Development in Bay City, MI. Web Designer and Developer | Jesse Dockett</title>
		<meta name="description" content="Jesse Dockett is a web designer and web developer from Bay City, Michigan. Jesse Dockett primarily works in front-end development with Wordpress and Joomla. Occasionally, he makes videos, too. Please contact Jesse Dockett directly if in need of web design or web development.">
	</head>
	<body>
		<?php
			include 'menu.php';
		?>
		<div id="content">
			<div id="content-container">
				<div class="twelve-columns bottom-border" style="margin-bottom:16px;">
					<h1>Jesse Dockett</h1>
					<h2>Web Developer / Software Engineer / Movie Maker</h2>
				</div>
				<div class="eight-columns">
					<p><span class="dropcap">M</span>y name is Jesse Dockett. I believe in creating beautiful, memorable experiences across the web. I believe mobile devices are changing the landscape of the internet and we should be designing for them first. I believe that good design is about what you leave out, not what you include. I believe in a better web. I love simple and elegant design, clean and usable interfaces, and semantic and scalable code. My focus is creating a pure web experience on every device. I also make short videos from time to time. I am currently working with <a href="http://ohnodesign.com/" target="_blank">Ohno Design</a>, but if you have something especially fun and exciting <a href="../contact">get in touch</a>.</p>
					<p><img src="../uploads/about-2018.jpg" alt="Photo of 'Jesse', his wife, 'Laura', and their dog, 'Molly'"></p>
					<h1 class="bottom-border">My Experience</h1>
					<p>The long winters in Michigan got me started on the web at a young age. I completed my first website at 14 years old. A friend was making simple computer games and he wanted a simple website to share his work with the world.</p>
					<h2>The Early Years</h2>
					<p>Shortly after making that first website I was introduced to Myspace. Myspace at the time was a great place for musicians and artists to share their work with the world. It also happened to be a great place for me to share my design and development chops with the world. I began styling pages for friends and even a few paying customers. I pushed Myspace's system to the absolute limit.</p>
					<p>In 2008 Myspace began to dry up and people began using Facebook instead. Since Facebook didn't have an interface that I could interact with, my outlet for web design was gone. Luckily, I was able to land an after school job at the local newspaper as a sort of photo intern that same year. After my internship ended, I was able to stay on as a freelance photographer for another year before the newspaper really began to downsize.</p>
					<h2>Freelancing</h2>
					<p>In 2011 I began honing my skills again. I made a few small websites and I was hooked again. I was quickly picked up by Ohno Design, a growing web design company to help them make the area's web presence more beautiful.</p>
					<h2>Ohno Design</h2>
					<p>I began working for Ohno Design part time in the late summer of 2012. While working with Ohno I have been able to explore my talents in design, development, and movie making. In my three years with them, I worked on over 100 websites and made about a dozen short movies. I had the opportunity to meet and work with some great people from some great organizations including NASA, The University of Michigan, and DOW.
					</p>
					<h2>BAISD Career Center</h2>
					<p>In 2017 I was offered an instructor position at the Bay Arenac ISD Career Center teaching software engineering and web development to high school juniors and seniors. My students have developed some amazing projects and I am proud to guide them on their path to become the software engineers and web developers of tomorrow. 
					</p>
					<h2>Digital Fox</h2>
					<p class="extra-large-margin-bottom">
					    In November of 2018 I partnered with some other talented IT professionals to form <a href="https://digitalfox.io" target = "_blank">Digital Fox</a>. We are a full service IT consulting, custom web and software development, marketing, networking, and cyber security company that is rapidly growing.
					</p>
				</div>
				<div class="four-columns">
					<h2 class="small-margin-top bottom-border-mobile-only">My Skill Set</h2>
					<p>My abilities are always expanding. I love to take on new challenges and solve difficult problems. Below is a list of what abilities I bring to the table.</p>
					<h3>Web Development</h3>
					<ul class="dashes">
						<li>XHTML/HTML5</li>
						<li>CSS3</li>
						<li>LESS</li>
						<li>Javascript</li>
						<li>jQuery</li>
						<li>Wordpress</li>
						<li>Joomla</li>
						<li>k2</li>
						<li>Bootstrap</li>
						<li>PHP</li>
						<li>SQL</li>
					</ul>
					<h3>Software Engineering</h3>
					<ul class="dashes">
						<li>C#</li>
						<li>Java</li>
						<li>Swift 2</li>
						<li>Python
						<li>Visual Studio</li>
						<li>IntelliJ Idea</li>
						<li>Xcode</li>
						<li>Pycharm</li>
						<li>Android Studio</li>
						<li>Git</li>
					</ul>
					<h3>UX/UI Design</h3>
					<ul class="dashes">
						<li>Photoshop</li>
						<li>Hype</li>
						<li>Typography</li>
						<li>Grid Systems</li>
						<li>Wireframes</li>
						<li>Prototypes</li>
					</ul>
					<h3>Movie Making</h3>
					<ul class="dashes">
						<li>Screenwriting</li>
						<li>Storyboarding</li>
						<li>Lighting</li>
						<li>Sound Design</li>
						<li>Direction</li>
						<li>Camera Operation</li>
						<li>Steadicam Operation</li>
						<li>Final Cut Pro X</li>
						<li>Motion 5</li>
					</ul>
					<h2 class="bottom-border">Download Resume</h2>
					<p>Looking to see how long I worked at 7-11 while I was in college? Download a PDF copy of my resume below.</p>
					<a href="../uploads/jesse-dockett-resume.pdf" target="_blank" class="btn">
						Download
					</a>
					<h2 class="bottom-border large-padding-top">Connect Online</h2>
					<p>If you're looking for some other pieces of my online presence, check out the links below.</p>
					<div class="social-icons centered">
						<a href="https://www.linkedin.com/pub/jesse-dockett/51/646/721" target="_blank">
							<i class="fa fa-linkedin fa-2x large-padding-top"></i>
							<br/>
							Linkedn
						</a>
					</div>
					<div class="social-icons centered">
						<a href="https://www.facebook.com/jdockett" target="_blank">
							<i class="fa fa-facebook fa-2x large-padding-top"></i>
							<br/>
							Facebook
						</a>
					</div>
					<div class="social-icons centered">
						<a href="https://twitter.com/" target="_blank">
							<i class="fa fa-twitter fa-2x large-padding-top"></i>
							<br/>
							Twitter
						</a>
					</div>
				</div>
				<?php
					include 'footer.php';
				?>
			</div>
		</div>
		<script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

  ga('create', 'UA-33934983-1', 'auto');
  ga('send', 'pageview');

</script>
	</body>
</html>
